//
//  ColorController.m
//  HelloWorld
//
//  Created by Erica Sadun on 4/30/10.
//  Copyright 2010 Up To No Good, Inc. All rights reserved.
//

#import "ColorControl.h"


@implementation ColorControl
@synthesize value;

- (id)initWithFrame:(CGRect)frame {
    if (!(self = [super initWithFrame:frame])) return nil;
	
	value = nil;
	self.backgroundColor = [UIColor grayColor];
	
    return self;
}

- (void) updateColorFromTouch: (UITouch *) touch
{
	// Określenie barwy i jej nasycenia.
	CGPoint touchPoint = [touch locationInView:self];
	float hue = touchPoint.x / self.frame.size.width;
	float saturation = touchPoint.y / self.frame.size.height;
	
	// Uaktualnienie wartości koloru i zmiana koloru tła.
	self.value = [UIColor colorWithHue:hue saturation:saturation brightness:1.0f alpha:1.0f];
	self.backgroundColor = self.value;
	[self sendActionsForControlEvents:UIControlEventValueChanged];
}

// Kontynuacja śledzenia dotknięcia w kontrolce.
- (BOOL) continueTrackingWithTouch: (UITouch *) touch withEvent: (UIEvent *) event
{
	// Sprawdzenie, czy miejsce dotknięcia znajduje się w kontrolce, czy poza nią.
	CGPoint touchPoint = [touch locationInView:self];
	if (CGRectContainsPoint(self.bounds, touchPoint))
		[self sendActionsForControlEvents:UIControlEventTouchDragInside];
	else 
		[self sendActionsForControlEvents:UIControlEventTouchDragOutside];
	
	// Uaktualnienie wartości koloru.
	[self updateColorFromTouch:touch];

	return YES;
}

// Rozpoczęcie śledzenia dotknięcia w kontrolce.
- (BOOL) beginTrackingWithTouch: (UITouch *) touch withEvent: (UIEvent *) event
{
	// Palec jest na ekranie.
	[self sendActionsForControlEvents:UIControlEventTouchDown];
	
	// Uaktualnienie wartości koloru.
	[self updateColorFromTouch:touch];
	
	return YES;
}

// Koniec śledzenia dotknięcia.
- (void) endTrackingWithTouch: (UITouch *)touch withEvent: (UIEvent *)event
{
	// Sprawdzenie, czy zakończenie dotknięcia nastąpiło w kontrolce, czy poza nią.
	CGPoint touchPoint = [touch locationInView:self];
	if (CGRectContainsPoint(self.bounds, touchPoint))
		[self sendActionsForControlEvents:UIControlEventTouchUpInside];
	else 
		[self sendActionsForControlEvents:UIControlEventTouchUpOutside];
	
	// Uaktualnienie wartości koloru.
	[self updateColorFromTouch:touch];
}


// Obsługa przerwania dotknięcia.
- (void)cancelTrackingWithEvent: (UIEvent *) event
{
	[self sendActionsForControlEvents:UIControlEventTouchCancel];
}


- (void)dealloc 
{
	self.value = nil;
}
@end
